#include <stdio.h>
#include <stdlib.h>
#include "mpi.h"
#define LEN 16777216

int main(int argc, char** argv) {

  double start=0.0, stop=0.0;
  double totalTime = 0.0;

  MPI_Init(&argc, &argv);				    

  MPI_Status status;

  char* sbuf     = (char *) malloc (LEN*sizeof(char));

  int WARM_UP = 5 ;
  int REPEAT = 20;			

  int j=1,i=0;   	       		   	
  int rank =0;
  int size = 0;
  int LOG2N_MAX = 1000000,log2nbyte=0,padding=0;	
  double timed = 0.0;		
  double latency = 0.0;
  int root = 0;
  for(i =0;i < LEN ;i++) {
    sbuf[i] = 's';
    //rbuf[i] = 'x';
  }
  
  MPI_Comm_rank(MPI_COMM_WORLD, &rank);  
  MPI_Comm_size(MPI_COMM_WORLD, &size);    

  /* Logrithmic Loop */
  for (log2nbyte = 0; (log2nbyte <= LOG2N_MAX) && (j < LEN); ++log2nbyte) { 

	j = (1 << log2nbyte);

	/* Warm Up Loop */
	for(i=0;i < WARM_UP ;i++) {
		MPI_Bcast( sbuf,j, MPI_CHAR, root, MPI_COMM_WORLD );	
	}
	
	/* Warm Up Loop */                
	start = MPI_Wtime();				
		
	/* Latency Calculation Loop */
	
	for (i = 0; i < REPEAT ; i++) {	   	
		MPI_Bcast( sbuf,j, MPI_CHAR, root, MPI_COMM_WORLD );
	}		
		
	stop = MPI_Wtime();
	timed = stop - start;			
	/* End latency calculation loop */
 	latency = ( ((timed)/(2*REPEAT) )*1000*1000);	
 	
 	double reduceIn = latency;
 	double reduceOut = 0.0;
 	
 	MPI_Reduce(&reduceIn, &reduceOut, 1, MPI_DOUBLE,
               MPI_SUM, root, MPI_COMM_WORLD);

 	
 	
	if(rank == 0) {
		latency = reduceOut/size;
        printf("%d\t%.2f\t%.2f\n", j , (latency), 
		            (( 8*j ) /( 1024*1024* (latency/(1000*1000)))) );
	}
    }//end logrithmic loop
    	 		
    MPI_Barrier(MPI_COMM_WORLD);    		
    MPI_Finalize();	  	
    return 0;
}
